function [pb_0 pb_1] = Calc_Pb(status)
% [pb_0 pb_1] = Calc_Pb(status)
%
% Input Variables
%   status- the status of all peaks
%
% Output Variables
%   pb_0 - Probablity for a min
%   pb_1 - Probablity for a max
%
% Description
%   checks all the detected QRS complex if they are in a positive peak or
%   not
% Created
%   8/23/2006, Mohamed A Mneimneh, Marquette University
%
% This software is released under the terms of the GNU General
% Public License (http://www.gnu.org/copyleft/gpl.html).
% Modified

pb_0 = 0;
pb_1 = 0;
for i = 1:length(status)
    if status(i) ==0
        pb_0 = pb_0 +1;
    else
        pb_1 = pb_1 +1;
    end
end

pb_0 = pb_0/length(status);
pb_1 = pb_1/length(status);